<?php

function total_get_google_font_variants() {

    $font_list = array_merge(total_default_font_array(), total_standard_font_array(), total_google_font_array());

    $total_font_family = isset($_REQUEST['font_family']) ? sanitize_text_field(wp_unslash($_REQUEST['font_family'])) : '';
    $font_array = total_search_key($font_list, 'family', $total_font_family);

    $variants_array = $font_array['0']['variants'];

    if ($variants_array) {
        foreach ($variants_array as $key => $variants) {
            $selected = $key == '400' ? 'selected="selected"' : '';
            ?>
            <option <?php echo esc_attr($selected); ?> value="<?php echo esc_attr($key); ?>"><?php echo esc_html($variants); ?></option>
            <?php
        }
    }
    die();
}

add_action("wp_ajax_total_get_google_font_variants", "total_get_google_font_variants");

function total_search_key($array, $key, $value) {
    $results = array();
    if (is_array($array)) {
        if (isset($array[$key]) && $array[$key] == $value) {
            $results[] = $array;
        }
        foreach ($array as $subarray) {
            $results = array_merge($results, total_search_key($subarray, $key, $value));
        }
    }
    return $results;
}

function total_default_font_array() {
    return array(
        'default' => array(
            'family' => 'Default',
            'variants' => array(
                '100' => esc_html__('Thin', 'total'),
                '300' => esc_html__('Light', 'total'),
                '400' => esc_html__('Normal', 'total'),
                '400italic' => esc_html__('Normal Italic', 'total'),
                '500' => esc_html__('Medium', 'total'),
                '600' => esc_html__('Semi Bold', 'total'),
                '700' => esc_html__('Bold', 'total'),
                '700italic' => esc_html__('Bold Italic', 'total')
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        )
    );
}

function total_google_font_array() {
    $google_font_json = '{"ABeeZee":{"family":"ABeeZee","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Abel":{"family":"Abel","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Abhaya Libre":{"family":"Abhaya Libre","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","sinhala":"Sinhala"}},"Abril Fatface":{"family":"Abril Fatface","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Aclonica":{"family":"Aclonica","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Acme":{"family":"Acme","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Actor":{"family":"Actor","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Adamina":{"family":"Adamina","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Advent Pro":{"family":"Advent Pro","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"greek":"Greek","latin":"Latin","latin-ext":"Latin Extended"}},"Aguafina Script":{"family":"Aguafina Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Akronim":{"family":"Akronim","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Aladin":{"family":"Aladin","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Alata":{"family":"Alata","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Alatsi":{"family":"Alatsi","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Aldrich":{"family":"Aldrich","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Alef":{"family":"Alef","variants":{"400":"Normal","700":"Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin"}},"Alegreya":{"family":"Alegreya","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Alegreya SC":{"family":"Alegreya SC","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Alegreya Sans":{"family":"Alegreya Sans","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Alegreya Sans SC":{"family":"Alegreya Sans SC","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Aleo":{"family":"Aleo","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Alex Brush":{"family":"Alex Brush","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Alfa Slab One":{"family":"Alfa Slab One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Alice":{"family":"Alice","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin"}},"Alike":{"family":"Alike","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Alike Angular":{"family":"Alike Angular","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Allan":{"family":"Allan","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Allerta":{"family":"Allerta","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Allerta Stencil":{"family":"Allerta Stencil","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Allura":{"family":"Allura","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Almarai":{"family":"Almarai","variants":{"300":"Light","400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"arabic":"Arabic"}},"Almendra":{"family":"Almendra","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Almendra Display":{"family":"Almendra Display","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Almendra SC":{"family":"Almendra SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Amarante":{"family":"Amarante","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Amaranth":{"family":"Amaranth","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Amatic SC":{"family":"Amatic SC","variants":{"400":"Normal","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Amethysta":{"family":"Amethysta","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Amiko":{"family":"Amiko","variants":{"400":"Normal","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Amiri":{"family":"Amiri","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Amita":{"family":"Amita","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Anaheim":{"family":"Anaheim","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Andada":{"family":"Andada","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Andika":{"family":"Andika","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Angkor":{"family":"Angkor","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Annie Use Your Telescope":{"family":"Annie Use Your Telescope","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Anonymous Pro":{"family":"Anonymous Pro","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended"}},"Antic":{"family":"Antic","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Antic Didone":{"family":"Antic Didone","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Antic Slab":{"family":"Antic Slab","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Anton":{"family":"Anton","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Arapey":{"family":"Arapey","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Arbutus":{"family":"Arbutus","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Arbutus Slab":{"family":"Arbutus Slab","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Architects Daughter":{"family":"Architects Daughter","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Archivo":{"family":"Archivo","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Archivo Black":{"family":"Archivo Black","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Archivo Narrow":{"family":"Archivo Narrow","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Aref Ruqaa":{"family":"Aref Ruqaa","variants":{"400":"Normal","700":"Bold"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Arima Madurai":{"family":"Arima Madurai","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil","vietnamese":"Vietnamese"}},"Arimo":{"family":"Arimo","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Arizonia":{"family":"Arizonia","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Armata":{"family":"Armata","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Arsenal":{"family":"Arsenal","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Artifika":{"family":"Artifika","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Arvo":{"family":"Arvo","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Arya":{"family":"Arya","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Asap":{"family":"Asap","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Asap Condensed":{"family":"Asap Condensed","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Asar":{"family":"Asar","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Asset":{"family":"Asset","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Assistant":{"family":"Assistant","variants":{"200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin"}},"Astloch":{"family":"Astloch","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Asul":{"family":"Asul","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Athiti":{"family":"Athiti","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Atma":{"family":"Atma","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"bengali":"Bengali","latin":"Latin","latin-ext":"Latin Extended"}},"Atomic Age":{"family":"Atomic Age","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Aubrey":{"family":"Aubrey","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Audiowide":{"family":"Audiowide","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Autour One":{"family":"Autour One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Average":{"family":"Average","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Average Sans":{"family":"Average Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Averia Gruesa Libre":{"family":"Averia Gruesa Libre","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Averia Libre":{"family":"Averia Libre","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Averia Sans Libre":{"family":"Averia Sans Libre","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Averia Serif Libre":{"family":"Averia Serif Libre","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"B612":{"family":"B612","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"B612 Mono":{"family":"B612 Mono","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Bad Script":{"family":"Bad Script","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin"}},"Bahiana":{"family":"Bahiana","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bahianita":{"family":"Bahianita","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bai Jamjuree":{"family":"Bai Jamjuree","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Baloo 2":{"family":"Baloo 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Baloo Bhai 2":{"family":"Baloo Bhai 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Baloo Bhaina 2":{"family":"Baloo Bhaina 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","oriya":"Oriya","vietnamese":"Vietnamese"}},"Baloo Chettan 2":{"family":"Baloo Chettan 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","malayalam":"Malayalam","vietnamese":"Vietnamese"}},"Baloo Da 2":{"family":"Baloo Da 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"bengali":"Bengali","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Baloo Paaji 2":{"family":"Baloo Paaji 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"gurmukhi":"Gurmukhi","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Baloo Tamma 2":{"family":"Baloo Tamma 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"kannada":"Kannada","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Baloo Tammudu 2":{"family":"Baloo Tammudu 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","telugu":"Telugu","vietnamese":"Vietnamese"}},"Baloo Thambi 2":{"family":"Baloo Thambi 2","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil","vietnamese":"Vietnamese"}},"Balsamiq Sans":{"family":"Balsamiq Sans","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Balthazar":{"family":"Balthazar","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bangers":{"family":"Bangers","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Barlow":{"family":"Barlow","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Barlow Condensed":{"family":"Barlow Condensed","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Barlow Semi Condensed":{"family":"Barlow Semi Condensed","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Barriecito":{"family":"Barriecito","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Barrio":{"family":"Barrio","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Basic":{"family":"Basic","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Baskervville":{"family":"Baskervville","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Battambang":{"family":"Battambang","variants":{"400":"Normal","700":"Bold"},"subsets":{"khmer":"Khmer"}},"Baumans":{"family":"Baumans","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bayon":{"family":"Bayon","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Be Vietnam":{"family":"Be Vietnam","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bebas Neue":{"family":"Bebas Neue","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Belgrano":{"family":"Belgrano","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bellefair":{"family":"Bellefair","variants":{"400":"Normal"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Belleza":{"family":"Belleza","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bellota":{"family":"Bellota","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bellota Text":{"family":"Bellota Text","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"BenchNine":{"family":"BenchNine","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bentham":{"family":"Bentham","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Berkshire Swash":{"family":"Berkshire Swash","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Beth Ellen":{"family":"Beth Ellen","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bevan":{"family":"Bevan","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Big Shoulders Display":{"family":"Big Shoulders Display","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Big Shoulders Text":{"family":"Big Shoulders Text","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bigelow Rules":{"family":"Bigelow Rules","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bigshot One":{"family":"Bigshot One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bilbo":{"family":"Bilbo","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bilbo Swash Caps":{"family":"Bilbo Swash Caps","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"BioRhyme":{"family":"BioRhyme","variants":{"200":"Extra Light","300":"Light","400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"BioRhyme Expanded":{"family":"BioRhyme Expanded","variants":{"200":"Extra Light","300":"Light","400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Biryani":{"family":"Biryani","variants":{"200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Bitter":{"family":"Bitter","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Black And White Picture":{"family":"Black And White Picture","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Black Han Sans":{"family":"Black Han Sans","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Black Ops One":{"family":"Black Ops One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Blinker":{"family":"Blinker","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bokor":{"family":"Bokor","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Bonbon":{"family":"Bonbon","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Boogaloo":{"family":"Boogaloo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bowlby One":{"family":"Bowlby One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bowlby One SC":{"family":"Bowlby One SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Brawler":{"family":"Brawler","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Bree Serif":{"family":"Bree Serif","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bubblegum Sans":{"family":"Bubblegum Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bubbler One":{"family":"Bubbler One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Buda":{"family":"Buda","variants":{"300":"Light"},"subsets":{"latin":"Latin"}},"Buenard":{"family":"Buenard","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Bungee":{"family":"Bungee","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bungee Hairline":{"family":"Bungee Hairline","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bungee Inline":{"family":"Bungee Inline","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bungee Outline":{"family":"Bungee Outline","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Bungee Shade":{"family":"Bungee Shade","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Butcherman":{"family":"Butcherman","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Butterfly Kids":{"family":"Butterfly Kids","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cabin":{"family":"Cabin","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cabin Condensed":{"family":"Cabin Condensed","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cabin Sketch":{"family":"Cabin Sketch","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Caesar Dressing":{"family":"Caesar Dressing","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cagliostro":{"family":"Cagliostro","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cairo":{"family":"Cairo","variants":{"200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Caladea":{"family":"Caladea","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Calistoga":{"family":"Calistoga","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Calligraffitti":{"family":"Calligraffitti","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cambay":{"family":"Cambay","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Cambo":{"family":"Cambo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Candal":{"family":"Candal","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cantarell":{"family":"Cantarell","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Cantata One":{"family":"Cantata One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cantora One":{"family":"Cantora One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Capriola":{"family":"Capriola","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cardo":{"family":"Cardo","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Carme":{"family":"Carme","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Carrois Gothic":{"family":"Carrois Gothic","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Carrois Gothic SC":{"family":"Carrois Gothic SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Carter One":{"family":"Carter One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Catamaran":{"family":"Catamaran","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil"}},"Caudex":{"family":"Caudex","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Caveat":{"family":"Caveat","variants":{"400":"Normal","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Caveat Brush":{"family":"Caveat Brush","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cedarville Cursive":{"family":"Cedarville Cursive","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Ceviche One":{"family":"Ceviche One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chakra Petch":{"family":"Chakra Petch","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Changa":{"family":"Changa","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Changa One":{"family":"Changa One","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Chango":{"family":"Chango","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Charm":{"family":"Charm","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Charmonman":{"family":"Charmonman","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Chathura":{"family":"Chathura","variants":{"100":"Thin","300":"Light","400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Chau Philomene One":{"family":"Chau Philomene One","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chela One":{"family":"Chela One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chelsea Market":{"family":"Chelsea Market","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chenla":{"family":"Chenla","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Cherry Cream Soda":{"family":"Cherry Cream Soda","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cherry Swash":{"family":"Cherry Swash","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chewy":{"family":"Chewy","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Chicle":{"family":"Chicle","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chilanka":{"family":"Chilanka","variants":{"400":"Normal"},"subsets":{"latin":"Latin","malayalam":"Malayalam"}},"Chivo":{"family":"Chivo","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Chonburi":{"family":"Chonburi","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Cinzel":{"family":"Cinzel","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cinzel Decorative":{"family":"Cinzel Decorative","variants":{"400":"Normal","700":"Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin"}},"Clicker Script":{"family":"Clicker Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Coda":{"family":"Coda","variants":{"400":"Normal","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Coda Caption":{"family":"Coda Caption","variants":{"800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Codystar":{"family":"Codystar","variants":{"300":"Light","400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Coiny":{"family":"Coiny","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil","vietnamese":"Vietnamese"}},"Combo":{"family":"Combo","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Comfortaa":{"family":"Comfortaa","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Comic Neue":{"family":"Comic Neue","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Coming Soon":{"family":"Coming Soon","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Concert One":{"family":"Concert One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Condiment":{"family":"Condiment","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Content":{"family":"Content","variants":{"400":"Normal","700":"Bold"},"subsets":{"khmer":"Khmer"}},"Contrail One":{"family":"Contrail One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Convergence":{"family":"Convergence","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cookie":{"family":"Cookie","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Copse":{"family":"Copse","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Corben":{"family":"Corben","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cormorant":{"family":"Cormorant","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cormorant Garamond":{"family":"Cormorant Garamond","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cormorant Infant":{"family":"Cormorant Infant","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cormorant SC":{"family":"Cormorant SC","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cormorant Unicase":{"family":"Cormorant Unicase","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cormorant Upright":{"family":"Cormorant Upright","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Courgette":{"family":"Courgette","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Courier Prime":{"family":"Courier Prime","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cousine":{"family":"Cousine","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Coustard":{"family":"Coustard","variants":{"400":"Normal","900":"Ultra Bold"},"subsets":{"latin":"Latin"}},"Covered By Your Grace":{"family":"Covered By Your Grace","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Crafty Girls":{"family":"Crafty Girls","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Creepster":{"family":"Creepster","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Crete Round":{"family":"Crete Round","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Crimson Pro":{"family":"Crimson Pro","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Crimson Text":{"family":"Crimson Text","variants":{"400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Croissant One":{"family":"Croissant One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Crushed":{"family":"Crushed","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Cuprum":{"family":"Cuprum","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Cute Font":{"family":"Cute Font","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Cutive":{"family":"Cutive","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Cutive Mono":{"family":"Cutive Mono","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"DM Mono":{"family":"DM Mono","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"DM Sans":{"family":"DM Sans","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"DM Serif Display":{"family":"DM Serif Display","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"DM Serif Text":{"family":"DM Serif Text","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Damion":{"family":"Damion","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Dancing Script":{"family":"Dancing Script","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Dangrek":{"family":"Dangrek","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Darker Grotesque":{"family":"Darker Grotesque","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"David Libre":{"family":"David Libre","variants":{"400":"Normal","500":"Medium","700":"Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Dawning of a New Day":{"family":"Dawning of a New Day","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Days One":{"family":"Days One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Dekko":{"family":"Dekko","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Delius":{"family":"Delius","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Delius Swash Caps":{"family":"Delius Swash Caps","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Delius Unicase":{"family":"Delius Unicase","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Della Respira":{"family":"Della Respira","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Denk One":{"family":"Denk One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Devonshire":{"family":"Devonshire","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Dhurjati":{"family":"Dhurjati","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Didact Gothic":{"family":"Didact Gothic","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Diplomata":{"family":"Diplomata","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Diplomata SC":{"family":"Diplomata SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Do Hyeon":{"family":"Do Hyeon","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Dokdo":{"family":"Dokdo","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Domine":{"family":"Domine","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Donegal One":{"family":"Donegal One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Doppio One":{"family":"Doppio One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Dorsa":{"family":"Dorsa","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Dosis":{"family":"Dosis","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Dr Sugiyama":{"family":"Dr Sugiyama","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Duru Sans":{"family":"Duru Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Dynalight":{"family":"Dynalight","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"EB Garamond":{"family":"EB Garamond","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Eagle Lake":{"family":"Eagle Lake","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"East Sea Dokdo":{"family":"East Sea Dokdo","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Eater":{"family":"Eater","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Economica":{"family":"Economica","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Eczar":{"family":"Eczar","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"El Messiri":{"family":"El Messiri","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"arabic":"Arabic","cyrillic":"Cyrillic","latin":"Latin"}},"Electrolize":{"family":"Electrolize","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Elsie":{"family":"Elsie","variants":{"400":"Normal","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Elsie Swash Caps":{"family":"Elsie Swash Caps","variants":{"400":"Normal","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Emblema One":{"family":"Emblema One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Emilys Candy":{"family":"Emilys Candy","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Encode Sans":{"family":"Encode Sans","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Encode Sans Condensed":{"family":"Encode Sans Condensed","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Encode Sans Expanded":{"family":"Encode Sans Expanded","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Encode Sans Semi Condensed":{"family":"Encode Sans Semi Condensed","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Encode Sans Semi Expanded":{"family":"Encode Sans Semi Expanded","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Engagement":{"family":"Engagement","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Englebert":{"family":"Englebert","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Enriqueta":{"family":"Enriqueta","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Epilogue":{"family":"Epilogue","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Erica One":{"family":"Erica One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Esteban":{"family":"Esteban","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Euphoria Script":{"family":"Euphoria Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ewert":{"family":"Ewert","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Exo":{"family":"Exo","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Exo 2":{"family":"Exo 2","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Expletus Sans":{"family":"Expletus Sans","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Fahkwang":{"family":"Fahkwang","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Fanwood Text":{"family":"Fanwood Text","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Farro":{"family":"Farro","variants":{"300":"Light","400":"Normal","500":"Medium","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Farsan":{"family":"Farsan","variants":{"400":"Normal"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Fascinate":{"family":"Fascinate","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Fascinate Inline":{"family":"Fascinate Inline","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Faster One":{"family":"Faster One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Fasthand":{"family":"Fasthand","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Fauna One":{"family":"Fauna One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Faustina":{"family":"Faustina","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Federant":{"family":"Federant","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Federo":{"family":"Federo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Felipa":{"family":"Felipa","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fenix":{"family":"Fenix","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Finger Paint":{"family":"Finger Paint","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Fira Code":{"family":"Fira Code","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Fira Mono":{"family":"Fira Mono","variants":{"400":"Normal","500":"Medium","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Fira Sans":{"family":"Fira Sans","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Fira Sans Condensed":{"family":"Fira Sans Condensed","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Fira Sans Extra Condensed":{"family":"Fira Sans Extra Condensed","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Fjalla One":{"family":"Fjalla One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fjord One":{"family":"Fjord One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Flamenco":{"family":"Flamenco","variants":{"300":"Light","400":"Normal"},"subsets":{"latin":"Latin"}},"Flavors":{"family":"Flavors","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fondamento":{"family":"Fondamento","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fontdiner Swanky":{"family":"Fontdiner Swanky","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Forum":{"family":"Forum","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Francois One":{"family":"Francois One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Frank Ruhl Libre":{"family":"Frank Ruhl Libre","variants":{"300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Freckle Face":{"family":"Freckle Face","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fredericka the Great":{"family":"Fredericka the Great","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fredoka One":{"family":"Fredoka One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Freehand":{"family":"Freehand","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Fresca":{"family":"Fresca","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Frijole":{"family":"Frijole","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Fruktur":{"family":"Fruktur","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Fugaz One":{"family":"Fugaz One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"GFS Didot":{"family":"GFS Didot","variants":{"400":"Normal"},"subsets":{"greek":"Greek"}},"GFS Neohellenic":{"family":"GFS Neohellenic","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"greek":"Greek"}},"Gabriela":{"family":"Gabriela","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin"}},"Gaegu":{"family":"Gaegu","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Gafata":{"family":"Gafata","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Galada":{"family":"Galada","variants":{"400":"Normal"},"subsets":{"bengali":"Bengali","latin":"Latin"}},"Galdeano":{"family":"Galdeano","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Galindo":{"family":"Galindo","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gamja Flower":{"family":"Gamja Flower","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Gayathri":{"family":"Gayathri","variants":{"100":"Thin","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","malayalam":"Malayalam"}},"Gelasio":{"family":"Gelasio","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Gentium Basic":{"family":"Gentium Basic","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gentium Book Basic":{"family":"Gentium Book Basic","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Geo":{"family":"Geo","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Geostar":{"family":"Geostar","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Geostar Fill":{"family":"Geostar Fill","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Germania One":{"family":"Germania One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Gidugu":{"family":"Gidugu","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Gilda Display":{"family":"Gilda Display","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Girassol":{"family":"Girassol","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Give You Glory":{"family":"Give You Glory","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Glass Antiqua":{"family":"Glass Antiqua","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Glegoo":{"family":"Glegoo","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Gloria Hallelujah":{"family":"Gloria Hallelujah","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Goblin One":{"family":"Goblin One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Gochi Hand":{"family":"Gochi Hand","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Gorditas":{"family":"Gorditas","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Gothic A1":{"family":"Gothic A1","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Gotu":{"family":"Gotu","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Goudy Bookletter 1911":{"family":"Goudy Bookletter 1911","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Graduate":{"family":"Graduate","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Grand Hotel":{"family":"Grand Hotel","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gravitas One":{"family":"Gravitas One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Great Vibes":{"family":"Great Vibes","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Grenze":{"family":"Grenze","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Grenze Gotisch":{"family":"Grenze Gotisch","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Griffy":{"family":"Griffy","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gruppo":{"family":"Gruppo","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gudea":{"family":"Gudea","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Gugi":{"family":"Gugi","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Gupter":{"family":"Gupter","variants":{"400":"Normal","500":"Medium","700":"Bold"},"subsets":{"latin":"Latin"}},"Gurajada":{"family":"Gurajada","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Habibi":{"family":"Habibi","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Halant":{"family":"Halant","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Hammersmith One":{"family":"Hammersmith One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Hanalei":{"family":"Hanalei","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Hanalei Fill":{"family":"Hanalei Fill","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Handlee":{"family":"Handlee","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Hanuman":{"family":"Hanuman","variants":{"400":"Normal","700":"Bold"},"subsets":{"khmer":"Khmer"}},"Happy Monkey":{"family":"Happy Monkey","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Harmattan":{"family":"Harmattan","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Headland One":{"family":"Headland One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Heebo":{"family":"Heebo","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin"}},"Henny Penny":{"family":"Henny Penny","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Hepta Slab":{"family":"Hepta Slab","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Herr Von Muellerhoff":{"family":"Herr Von Muellerhoff","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Hi Melody":{"family":"Hi Melody","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Hind":{"family":"Hind","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Hind Guntur":{"family":"Hind Guntur","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","telugu":"Telugu"}},"Hind Madurai":{"family":"Hind Madurai","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil"}},"Hind Siliguri":{"family":"Hind Siliguri","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"bengali":"Bengali","latin":"Latin","latin-ext":"Latin Extended"}},"Hind Vadodara":{"family":"Hind Vadodara","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Holtwood One SC":{"family":"Holtwood One SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Homemade Apple":{"family":"Homemade Apple","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Homenaje":{"family":"Homenaje","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"IBM Plex Mono":{"family":"IBM Plex Mono","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"IBM Plex Sans":{"family":"IBM Plex Sans","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"IBM Plex Sans Condensed":{"family":"IBM Plex Sans Condensed","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"IBM Plex Serif":{"family":"IBM Plex Serif","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"IM Fell DW Pica":{"family":"IM Fell DW Pica","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"IM Fell DW Pica SC":{"family":"IM Fell DW Pica SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"IM Fell Double Pica":{"family":"IM Fell Double Pica","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"IM Fell Double Pica SC":{"family":"IM Fell Double Pica SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"IM Fell English":{"family":"IM Fell English","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"IM Fell English SC":{"family":"IM Fell English SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"IM Fell French Canon":{"family":"IM Fell French Canon","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"IM Fell French Canon SC":{"family":"IM Fell French Canon SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"IM Fell Great Primer":{"family":"IM Fell Great Primer","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"IM Fell Great Primer SC":{"family":"IM Fell Great Primer SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Ibarra Real Nova":{"family":"Ibarra Real Nova","variants":{"400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Iceberg":{"family":"Iceberg","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Iceland":{"family":"Iceland","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Imprima":{"family":"Imprima","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Inconsolata":{"family":"Inconsolata","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Inder":{"family":"Inder","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Indie Flower":{"family":"Indie Flower","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Inika":{"family":"Inika","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Inknut Antiqua":{"family":"Inknut Antiqua","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Inria Sans":{"family":"Inria Sans","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Inria Serif":{"family":"Inria Serif","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Inter":{"family":"Inter","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Irish Grover":{"family":"Irish Grover","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Istok Web":{"family":"Istok Web","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Italiana":{"family":"Italiana","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Italianno":{"family":"Italianno","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Itim":{"family":"Itim","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Jacques Francois":{"family":"Jacques Francois","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Jacques Francois Shadow":{"family":"Jacques Francois Shadow","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Jaldi":{"family":"Jaldi","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Jim Nightshade":{"family":"Jim Nightshade","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Jockey One":{"family":"Jockey One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Jolly Lodger":{"family":"Jolly Lodger","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Jomhuria":{"family":"Jomhuria","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Jomolhari":{"family":"Jomolhari","variants":{"400":"Normal"},"subsets":{"latin":"Latin","tibetan":null}},"Josefin Sans":{"family":"Josefin Sans","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Josefin Slab":{"family":"Josefin Slab","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Jost":{"family":"Jost","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Joti One":{"family":"Joti One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Jua":{"family":"Jua","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Judson":{"family":"Judson","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Julee":{"family":"Julee","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Julius Sans One":{"family":"Julius Sans One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Junge":{"family":"Junge","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Jura":{"family":"Jura","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Just Another Hand":{"family":"Just Another Hand","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Just Me Again Down Here":{"family":"Just Me Again Down Here","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"K2D":{"family":"K2D","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Kadwa":{"family":"Kadwa","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin"}},"Kalam":{"family":"Kalam","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Kameron":{"family":"Kameron","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Kanit":{"family":"Kanit","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Kantumruy":{"family":"Kantumruy","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"khmer":"Khmer"}},"Karla":{"family":"Karla","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Karma":{"family":"Karma","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Katibeh":{"family":"Katibeh","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Kaushan Script":{"family":"Kaushan Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Kavivanar":{"family":"Kavivanar","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil"}},"Kavoon":{"family":"Kavoon","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Kdam Thmor":{"family":"Kdam Thmor","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Keania One":{"family":"Keania One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Kelly Slab":{"family":"Kelly Slab","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Kenia":{"family":"Kenia","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Khand":{"family":"Khand","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Khmer":{"family":"Khmer","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Khula":{"family":"Khula","variants":{"300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Kirang Haerang":{"family":"Kirang Haerang","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Kite One":{"family":"Kite One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Knewave":{"family":"Knewave","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"KoHo":{"family":"KoHo","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Kodchasan":{"family":"Kodchasan","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Kosugi":{"family":"Kosugi","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","japanese":null,"latin":"Latin"}},"Kosugi Maru":{"family":"Kosugi Maru","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","japanese":null,"latin":"Latin"}},"Kotta One":{"family":"Kotta One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Koulen":{"family":"Koulen","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Kranky":{"family":"Kranky","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Kreon":{"family":"Kreon","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Kristi":{"family":"Kristi","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Krona One":{"family":"Krona One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Krub":{"family":"Krub","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Kulim Park":{"family":"Kulim Park","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Kumar One":{"family":"Kumar One","variants":{"400":"Normal"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Kumar One Outline":{"family":"Kumar One Outline","variants":{"400":"Normal"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Kurale":{"family":"Kurale","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"La Belle Aurore":{"family":"La Belle Aurore","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Lacquer":{"family":"Lacquer","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Laila":{"family":"Laila","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Lakki Reddy":{"family":"Lakki Reddy","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Lalezar":{"family":"Lalezar","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lancelot":{"family":"Lancelot","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Lateef":{"family":"Lateef","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Lato":{"family":"Lato","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"League Script":{"family":"League Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Leckerli One":{"family":"Leckerli One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Ledger":{"family":"Ledger","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Lekton":{"family":"Lekton","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Lemon":{"family":"Lemon","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Lemonada":{"family":"Lemonada","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Deca":{"family":"Lexend Deca","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Exa":{"family":"Lexend Exa","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Giga":{"family":"Lexend Giga","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Mega":{"family":"Lexend Mega","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Peta":{"family":"Lexend Peta","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Tera":{"family":"Lexend Tera","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lexend Zetta":{"family":"Lexend Zetta","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Libre Barcode 128":{"family":"Libre Barcode 128","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Barcode 128 Text":{"family":"Libre Barcode 128 Text","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Barcode 39":{"family":"Libre Barcode 39","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Barcode 39 Extended":{"family":"Libre Barcode 39 Extended","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Barcode 39 Extended Text":{"family":"Libre Barcode 39 Extended Text","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Barcode 39 Text":{"family":"Libre Barcode 39 Text","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Libre Baskerville":{"family":"Libre Baskerville","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Libre Caslon Display":{"family":"Libre Caslon Display","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Libre Caslon Text":{"family":"Libre Caslon Text","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Libre Franklin":{"family":"Libre Franklin","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Life Savers":{"family":"Life Savers","variants":{"400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Lilita One":{"family":"Lilita One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Lily Script One":{"family":"Lily Script One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Limelight":{"family":"Limelight","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Linden Hill":{"family":"Linden Hill","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Literata":{"family":"Literata","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Liu Jian Mao Cao":{"family":"Liu Jian Mao Cao","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Livvic":{"family":"Livvic","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lobster":{"family":"Lobster","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Lobster Two":{"family":"Lobster Two","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Londrina Outline":{"family":"Londrina Outline","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Londrina Shadow":{"family":"Londrina Shadow","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Londrina Sketch":{"family":"Londrina Sketch","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Londrina Solid":{"family":"Londrina Solid","variants":{"100":"Thin","300":"Light","400":"Normal","900":"Ultra Bold"},"subsets":{"latin":"Latin"}},"Long Cang":{"family":"Long Cang","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Lora":{"family":"Lora","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Love Ya Like A Sister":{"family":"Love Ya Like A Sister","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Loved by the King":{"family":"Loved by the King","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Lovers Quarrel":{"family":"Lovers Quarrel","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Luckiest Guy":{"family":"Luckiest Guy","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Lusitana":{"family":"Lusitana","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Lustria":{"family":"Lustria","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"M PLUS 1p":{"family":"M PLUS 1p","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","hebrew":"Hebrew","japanese":null,"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"M PLUS Rounded 1c":{"family":"M PLUS Rounded 1c","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","hebrew":"Hebrew","japanese":null,"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Ma Shan Zheng":{"family":"Ma Shan Zheng","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Macondo":{"family":"Macondo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Macondo Swash Caps":{"family":"Macondo Swash Caps","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Mada":{"family":"Mada","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Magra":{"family":"Magra","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Maiden Orange":{"family":"Maiden Orange","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Maitree":{"family":"Maitree","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Major Mono Display":{"family":"Major Mono Display","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Mako":{"family":"Mako","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Mali":{"family":"Mali","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Mallanna":{"family":"Mallanna","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Mandali":{"family":"Mandali","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Manjari":{"family":"Manjari","variants":{"100":"Thin","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","malayalam":"Malayalam"}},"Manrope":{"family":"Manrope","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"cyrillic":"Cyrillic","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended"}},"Mansalva":{"family":"Mansalva","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Manuale":{"family":"Manuale","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Marcellus":{"family":"Marcellus","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Marcellus SC":{"family":"Marcellus SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Marck Script":{"family":"Marck Script","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Margarine":{"family":"Margarine","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Markazi Text":{"family":"Markazi Text","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Marko One":{"family":"Marko One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Marmelad":{"family":"Marmelad","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Martel":{"family":"Martel","variants":{"200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Martel Sans":{"family":"Martel Sans","variants":{"200":"Extra Light","300":"Light","400":"Normal","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Marvel":{"family":"Marvel","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Mate":{"family":"Mate","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Mate SC":{"family":"Mate SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Maven Pro":{"family":"Maven Pro","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"McLaren":{"family":"McLaren","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Meddon":{"family":"Meddon","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"MedievalSharp":{"family":"MedievalSharp","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Medula One":{"family":"Medula One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Meera Inimai":{"family":"Meera Inimai","variants":{"400":"Normal"},"subsets":{"latin":"Latin","tamil":"Tamil"}},"Megrim":{"family":"Megrim","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Meie Script":{"family":"Meie Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Merienda":{"family":"Merienda","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Merienda One":{"family":"Merienda One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Merriweather":{"family":"Merriweather","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Merriweather Sans":{"family":"Merriweather Sans","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic"},"subsets":{"cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Metal":{"family":"Metal","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Metal Mania":{"family":"Metal Mania","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Metamorphous":{"family":"Metamorphous","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Metrophobic":{"family":"Metrophobic","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Michroma":{"family":"Michroma","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Milonga":{"family":"Milonga","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Miltonian":{"family":"Miltonian","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Miltonian Tattoo":{"family":"Miltonian Tattoo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Mina":{"family":"Mina","variants":{"400":"Normal","700":"Bold"},"subsets":{"bengali":"Bengali","latin":"Latin","latin-ext":"Latin Extended"}},"Miniver":{"family":"Miniver","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Miriam Libre":{"family":"Miriam Libre","variants":{"400":"Normal","700":"Bold"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Mirza":{"family":"Mirza","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Miss Fajardose":{"family":"Miss Fajardose","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mitr":{"family":"Mitr","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Modak":{"family":"Modak","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Modern Antiqua":{"family":"Modern Antiqua","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mogra":{"family":"Mogra","variants":{"400":"Normal"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Molengo":{"family":"Molengo","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Molle":{"family":"Molle","variants":{"400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Monda":{"family":"Monda","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Monofett":{"family":"Monofett","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Monoton":{"family":"Monoton","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Monsieur La Doulaise":{"family":"Monsieur La Doulaise","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Montaga":{"family":"Montaga","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Montez":{"family":"Montez","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Montserrat":{"family":"Montserrat","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Montserrat Alternates":{"family":"Montserrat Alternates","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Montserrat Subrayada":{"family":"Montserrat Subrayada","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Moul":{"family":"Moul","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Moulpali":{"family":"Moulpali","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Mountains of Christmas":{"family":"Mountains of Christmas","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Mouse Memoirs":{"family":"Mouse Memoirs","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mr Bedfort":{"family":"Mr Bedfort","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mr Dafoe":{"family":"Mr Dafoe","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mr De Haviland":{"family":"Mr De Haviland","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mrs Saint Delafield":{"family":"Mrs Saint Delafield","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mrs Sheppards":{"family":"Mrs Sheppards","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Mukta":{"family":"Mukta","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Mukta Mahee":{"family":"Mukta Mahee","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"gurmukhi":"Gurmukhi","latin":"Latin","latin-ext":"Latin Extended"}},"Mukta Malar":{"family":"Mukta Malar","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil"}},"Mukta Vaani":{"family":"Mukta Vaani","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Mulish":{"family":"Mulish","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"MuseoModerno":{"family":"MuseoModerno","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Mystery Quest":{"family":"Mystery Quest","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"NTR":{"family":"NTR","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Nanum Brush Script":{"family":"Nanum Brush Script","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Nanum Gothic":{"family":"Nanum Gothic","variants":{"400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Nanum Gothic Coding":{"family":"Nanum Gothic Coding","variants":{"400":"Normal","700":"Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Nanum Myeongjo":{"family":"Nanum Myeongjo","variants":{"400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Nanum Pen Script":{"family":"Nanum Pen Script","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Neucha":{"family":"Neucha","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin"}},"Neuton":{"family":"Neuton","variants":{"200":"Extra Light","300":"Light","400":"Normal","400italic":"Normal Italic","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"New Rocker":{"family":"New Rocker","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"News Cycle":{"family":"News Cycle","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Niconne":{"family":"Niconne","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Niramit":{"family":"Niramit","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Nixie One":{"family":"Nixie One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nobile":{"family":"Nobile","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Nokora":{"family":"Nokora","variants":{"400":"Normal","700":"Bold"},"subsets":{"khmer":"Khmer"}},"Norican":{"family":"Norican","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Nosifer":{"family":"Nosifer","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Notable":{"family":"Notable","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nothing You Could Do":{"family":"Nothing You Could Do","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Noticia Text":{"family":"Noticia Text","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Noto Sans":{"family":"Noto Sans","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","devanagari":"Devanagari","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Noto Sans HK":{"family":"Noto Sans HK","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"chinese-hongkong":null,"latin":"Latin"}},"Noto Sans JP":{"family":"Noto Sans JP","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"japanese":null,"latin":"Latin"}},"Noto Sans KR":{"family":"Noto Sans KR","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Noto Sans SC":{"family":"Noto Sans SC","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Noto Sans TC":{"family":"Noto Sans TC","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"chinese-traditional":null,"latin":"Latin"}},"Noto Serif":{"family":"Noto Serif","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Noto Serif JP":{"family":"Noto Serif JP","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"japanese":null,"latin":"Latin"}},"Noto Serif KR":{"family":"Noto Serif KR","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Noto Serif SC":{"family":"Noto Serif SC","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Noto Serif TC":{"family":"Noto Serif TC","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"chinese-traditional":null,"latin":"Latin"}},"Nova Cut":{"family":"Nova Cut","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Flat":{"family":"Nova Flat","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Mono":{"family":"Nova Mono","variants":{"400":"Normal"},"subsets":{"greek":"Greek","latin":"Latin"}},"Nova Oval":{"family":"Nova Oval","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Round":{"family":"Nova Round","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Script":{"family":"Nova Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Slim":{"family":"Nova Slim","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nova Square":{"family":"Nova Square","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Numans":{"family":"Numans","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Nunito":{"family":"Nunito","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Nunito Sans":{"family":"Nunito Sans","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Odibee Sans":{"family":"Odibee Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Odor Mean Chey":{"family":"Odor Mean Chey","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Offside":{"family":"Offside","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Old Standard TT":{"family":"Old Standard TT","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Oldenburg":{"family":"Oldenburg","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Oleo Script":{"family":"Oleo Script","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Oleo Script Swash Caps":{"family":"Oleo Script Swash Caps","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Open Sans":{"family":"Open Sans","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Open Sans Condensed":{"family":"Open Sans Condensed","variants":{"300":"Light","300italic":"Light Italic","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Oranienbaum":{"family":"Oranienbaum","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Orbitron":{"family":"Orbitron","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin"}},"Oregano":{"family":"Oregano","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Orienta":{"family":"Orienta","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Original Surfer":{"family":"Original Surfer","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Oswald":{"family":"Oswald","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Over the Rainbow":{"family":"Over the Rainbow","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Overlock":{"family":"Overlock","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Overlock SC":{"family":"Overlock SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Overpass":{"family":"Overpass","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Overpass Mono":{"family":"Overpass Mono","variants":{"300":"Light","400":"Normal","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ovo":{"family":"Ovo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Oxanium":{"family":"Oxanium","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Oxygen":{"family":"Oxygen","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Oxygen Mono":{"family":"Oxygen Mono","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"PT Mono":{"family":"PT Mono","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"PT Sans":{"family":"PT Sans","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"PT Sans Caption":{"family":"PT Sans Caption","variants":{"400":"Normal","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"PT Sans Narrow":{"family":"PT Sans Narrow","variants":{"400":"Normal","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"PT Serif":{"family":"PT Serif","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"PT Serif Caption":{"family":"PT Serif Caption","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Pacifico":{"family":"Pacifico","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Padauk":{"family":"Padauk","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","myanmar":"Myanmar"}},"Palanquin":{"family":"Palanquin","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Palanquin Dark":{"family":"Palanquin Dark","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Pangolin":{"family":"Pangolin","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Paprika":{"family":"Paprika","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Parisienne":{"family":"Parisienne","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Passero One":{"family":"Passero One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Passion One":{"family":"Passion One","variants":{"400":"Normal","700":"Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Pathway Gothic One":{"family":"Pathway Gothic One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Patrick Hand":{"family":"Patrick Hand","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Patrick Hand SC":{"family":"Patrick Hand SC","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Pattaya":{"family":"Pattaya","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Patua One":{"family":"Patua One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Pavanam":{"family":"Pavanam","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","tamil":"Tamil"}},"Paytone One":{"family":"Paytone One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Peddana":{"family":"Peddana","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Peralta":{"family":"Peralta","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Permanent Marker":{"family":"Permanent Marker","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Petit Formal Script":{"family":"Petit Formal Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Petrona":{"family":"Petrona","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Philosopher":{"family":"Philosopher","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","vietnamese":"Vietnamese"}},"Piedra":{"family":"Piedra","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Pinyon Script":{"family":"Pinyon Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Pirata One":{"family":"Pirata One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Plaster":{"family":"Plaster","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Play":{"family":"Play","variants":{"400":"Normal","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Playball":{"family":"Playball","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Playfair Display":{"family":"Playfair Display","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Playfair Display SC":{"family":"Playfair Display SC","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Podkova":{"family":"Podkova","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Poiret One":{"family":"Poiret One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Poller One":{"family":"Poller One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Poly":{"family":"Poly","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin"}},"Pompiere":{"family":"Pompiere","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Pontano Sans":{"family":"Pontano Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Poor Story":{"family":"Poor Story","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Poppins":{"family":"Poppins","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Port Lligat Sans":{"family":"Port Lligat Sans","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Port Lligat Slab":{"family":"Port Lligat Slab","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Pragati Narrow":{"family":"Pragati Narrow","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Prata":{"family":"Prata","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","vietnamese":"Vietnamese"}},"Preahvihear":{"family":"Preahvihear","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Press Start 2P":{"family":"Press Start 2P","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended"}},"Pridi":{"family":"Pridi","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Princess Sofia":{"family":"Princess Sofia","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Prociono":{"family":"Prociono","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Prompt":{"family":"Prompt","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Prosto One":{"family":"Prosto One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Proza Libre":{"family":"Proza Libre","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Public Sans":{"family":"Public Sans","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Puritan":{"family":"Puritan","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Purple Purse":{"family":"Purple Purse","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Quando":{"family":"Quando","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Quantico":{"family":"Quantico","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Quattrocento":{"family":"Quattrocento","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Quattrocento Sans":{"family":"Quattrocento Sans","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Questrial":{"family":"Questrial","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Quicksand":{"family":"Quicksand","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Quintessential":{"family":"Quintessential","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Qwigley":{"family":"Qwigley","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Racing Sans One":{"family":"Racing Sans One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Radley":{"family":"Radley","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rajdhani":{"family":"Rajdhani","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Rakkas":{"family":"Rakkas","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin","latin-ext":"Latin Extended"}},"Raleway":{"family":"Raleway","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Raleway Dots":{"family":"Raleway Dots","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ramabhadra":{"family":"Ramabhadra","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Ramaraja":{"family":"Ramaraja","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Rambla":{"family":"Rambla","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rammetto One":{"family":"Rammetto One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ranchers":{"family":"Ranchers","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rancho":{"family":"Rancho","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Ranga":{"family":"Ranga","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Rasa":{"family":"Rasa","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Rationale":{"family":"Rationale","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Ravi Prakash":{"family":"Ravi Prakash","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Recursive":{"family":"Recursive","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","vietnamese":"Vietnamese"}},"Red Hat Display":{"family":"Red Hat Display","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Red Hat Text":{"family":"Red Hat Text","variants":{"400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Red Rose":{"family":"Red Rose","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Redressed":{"family":"Redressed","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Reem Kufi":{"family":"Reem Kufi","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Reenie Beanie":{"family":"Reenie Beanie","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Revalia":{"family":"Revalia","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rhodium Libre":{"family":"Rhodium Libre","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Ribeye":{"family":"Ribeye","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ribeye Marrow":{"family":"Ribeye Marrow","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Righteous":{"family":"Righteous","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Risque":{"family":"Risque","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Roboto":{"family":"Roboto","variants":{"100":"Thin","100italic":"Thin Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Roboto Condensed":{"family":"Roboto Condensed","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Roboto Mono":{"family":"Roboto Mono","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Roboto Slab":{"family":"Roboto Slab","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Rochester":{"family":"Rochester","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Rock Salt":{"family":"Rock Salt","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Rokkitt":{"family":"Rokkitt","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Romanesco":{"family":"Romanesco","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ropa Sans":{"family":"Ropa Sans","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rosario":{"family":"Rosario","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Rosarivo":{"family":"Rosarivo","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rouge Script":{"family":"Rouge Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Rowdies":{"family":"Rowdies","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Rozha One":{"family":"Rozha One","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Rubik":{"family":"Rubik","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Rubik Mono One":{"family":"Rubik Mono One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Ruda":{"family":"Ruda","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Rufina":{"family":"Rufina","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ruge Boogie":{"family":"Ruge Boogie","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ruluko":{"family":"Ruluko","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rum Raisin":{"family":"Rum Raisin","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ruslan Display":{"family":"Ruslan Display","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Russo One":{"family":"Russo One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Ruthie":{"family":"Ruthie","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Rye":{"family":"Rye","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sacramento":{"family":"Sacramento","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sahitya":{"family":"Sahitya","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin"}},"Sail":{"family":"Sail","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Saira":{"family":"Saira","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Saira Condensed":{"family":"Saira Condensed","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Saira Extra Condensed":{"family":"Saira Extra Condensed","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Saira Semi Condensed":{"family":"Saira Semi Condensed","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Saira Stencil One":{"family":"Saira Stencil One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Salsa":{"family":"Salsa","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sanchez":{"family":"Sanchez","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sancreek":{"family":"Sancreek","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sansita":{"family":"Sansita","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sarabun":{"family":"Sarabun","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Sarala":{"family":"Sarala","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Sarina":{"family":"Sarina","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sarpanch":{"family":"Sarpanch","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Satisfy":{"family":"Satisfy","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sawarabi Gothic":{"family":"Sawarabi Gothic","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","japanese":null,"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Sawarabi Mincho":{"family":"Sawarabi Mincho","variants":{"400":"Normal"},"subsets":{"japanese":null,"latin":"Latin","latin-ext":"Latin Extended"}},"Scada":{"family":"Scada","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Scheherazade":{"family":"Scheherazade","variants":{"400":"Normal","700":"Bold"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Schoolbell":{"family":"Schoolbell","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Scope One":{"family":"Scope One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Seaweed Script":{"family":"Seaweed Script","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Secular One":{"family":"Secular One","variants":{"400":"Normal"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Sedgwick Ave":{"family":"Sedgwick Ave","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Sedgwick Ave Display":{"family":"Sedgwick Ave Display","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Sen":{"family":"Sen","variants":{"400":"Normal","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sevillana":{"family":"Sevillana","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Seymour One":{"family":"Seymour One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Shadows Into Light":{"family":"Shadows Into Light","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Shadows Into Light Two":{"family":"Shadows Into Light Two","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Shanti":{"family":"Shanti","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Share":{"family":"Share","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Share Tech":{"family":"Share Tech","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Share Tech Mono":{"family":"Share Tech Mono","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Shojumaru":{"family":"Shojumaru","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Short Stack":{"family":"Short Stack","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Shrikhand":{"family":"Shrikhand","variants":{"400":"Normal"},"subsets":{"gujarati":"Gujarati","latin":"Latin","latin-ext":"Latin Extended"}},"Siemreap":{"family":"Siemreap","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Sigmar One":{"family":"Sigmar One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Signika":{"family":"Signika","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Signika Negative":{"family":"Signika Negative","variants":{"300":"Light","400":"Normal","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Simonetta":{"family":"Simonetta","variants":{"400":"Normal","400italic":"Normal Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Single Day":{"family":"Single Day","variants":{"400":"Normal"},"subsets":{"korean":null}},"Sintony":{"family":"Sintony","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sirin Stencil":{"family":"Sirin Stencil","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Six Caps":{"family":"Six Caps","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Skranji":{"family":"Skranji","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Slabo 13px":{"family":"Slabo 13px","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Slabo 27px":{"family":"Slabo 27px","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Slackey":{"family":"Slackey","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Smokum":{"family":"Smokum","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Smythe":{"family":"Smythe","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sniglet":{"family":"Sniglet","variants":{"400":"Normal","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Snippet":{"family":"Snippet","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Snowburst One":{"family":"Snowburst One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sofadi One":{"family":"Sofadi One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sofia":{"family":"Sofia","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Solway":{"family":"Solway","variants":{"300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin"}},"Song Myung":{"family":"Song Myung","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Sonsie One":{"family":"Sonsie One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sora":{"family":"Sora","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sorts Mill Goudy":{"family":"Sorts Mill Goudy","variants":{"400":"Normal","400italic":"Normal Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Source Code Pro":{"family":"Source Code Pro","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Source Sans Pro":{"family":"Source Sans Pro","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Source Serif Pro":{"family":"Source Serif Pro","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Space Mono":{"family":"Space Mono","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Spartan":{"family":"Spartan","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Special Elite":{"family":"Special Elite","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Spectral":{"family":"Spectral","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Spectral SC":{"family":"Spectral SC","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Spicy Rice":{"family":"Spicy Rice","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Spinnaker":{"family":"Spinnaker","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Spirax":{"family":"Spirax","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Squada One":{"family":"Squada One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sree Krushnadevaraya":{"family":"Sree Krushnadevaraya","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Sriracha":{"family":"Sriracha","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Srisakdi":{"family":"Srisakdi","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Staatliches":{"family":"Staatliches","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Stalemate":{"family":"Stalemate","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Stalinist One":{"family":"Stalinist One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Stardos Stencil":{"family":"Stardos Stencil","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Stint Ultra Condensed":{"family":"Stint Ultra Condensed","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Stint Ultra Expanded":{"family":"Stint Ultra Expanded","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Stoke":{"family":"Stoke","variants":{"300":"Light","400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Strait":{"family":"Strait","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Stylish":{"family":"Stylish","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Sue Ellen Francisco":{"family":"Sue Ellen Francisco","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Suez One":{"family":"Suez One","variants":{"400":"Normal"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended"}},"Sulphur Point":{"family":"Sulphur Point","variants":{"300":"Light","400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Sumana":{"family":"Sumana","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Sunflower":{"family":"Sunflower","variants":{"300":"Light","500":"Medium","700":"Bold"},"subsets":{"korean":null,"latin":"Latin"}},"Sunshiney":{"family":"Sunshiney","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Supermercado One":{"family":"Supermercado One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Sura":{"family":"Sura","variants":{"400":"Normal","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Suranna":{"family":"Suranna","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Suravaram":{"family":"Suravaram","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Suwannaphum":{"family":"Suwannaphum","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Swanky and Moo Moo":{"family":"Swanky and Moo Moo","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Syncopate":{"family":"Syncopate","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Tajawal":{"family":"Tajawal","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold","900":"Ultra Bold"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Tangerine":{"family":"Tangerine","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Taprom":{"family":"Taprom","variants":{"400":"Normal"},"subsets":{"khmer":"Khmer"}},"Tauri":{"family":"Tauri","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Taviraj":{"family":"Taviraj","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Teko":{"family":"Teko","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Telex":{"family":"Telex","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Tenali Ramakrishna":{"family":"Tenali Ramakrishna","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Tenor Sans":{"family":"Tenor Sans","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Text Me One":{"family":"Text Me One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Thasadith":{"family":"Thasadith","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"The Girl Next Door":{"family":"The Girl Next Door","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Tienne":{"family":"Tienne","variants":{"400":"Normal","700":"Bold","900":"Ultra Bold"},"subsets":{"latin":"Latin"}},"Tillana":{"family":"Tillana","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Timmana":{"family":"Timmana","variants":{"400":"Normal"},"subsets":{"latin":"Latin","telugu":"Telugu"}},"Tinos":{"family":"Tinos","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Titan One":{"family":"Titan One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Titillium Web":{"family":"Titillium Web","variants":{"200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","900":"Ultra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Tomorrow":{"family":"Tomorrow","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Trade Winds":{"family":"Trade Winds","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Trirong":{"family":"Trirong","variants":{"100":"Thin","100italic":"Thin Italic","200":"Extra Light","200italic":"Extra Light Italic","300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic","800":"Extra Bold","800italic":"Extra Bold Italic","900":"Ultra Bold","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","thai":"Thai","vietnamese":"Vietnamese"}},"Trocchi":{"family":"Trocchi","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Trochut":{"family":"Trochut","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold"},"subsets":{"latin":"Latin"}},"Trykker":{"family":"Trykker","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Tulpen One":{"family":"Tulpen One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Turret Road":{"family":"Turret Road","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","700":"Bold","800":"Extra Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Ubuntu":{"family":"Ubuntu","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Ubuntu Condensed":{"family":"Ubuntu Condensed","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Ubuntu Mono":{"family":"Ubuntu Mono","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","greek-ext":"Greek Extended","latin":"Latin","latin-ext":"Latin Extended"}},"Ultra":{"family":"Ultra","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Uncial Antiqua":{"family":"Uncial Antiqua","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Underdog":{"family":"Underdog","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended"}},"Unica One":{"family":"Unica One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"UnifrakturCook":{"family":"UnifrakturCook","variants":{"700":"Bold"},"subsets":{"latin":"Latin"}},"UnifrakturMaguntia":{"family":"UnifrakturMaguntia","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Unkempt":{"family":"Unkempt","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin"}},"Unlock":{"family":"Unlock","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Unna":{"family":"Unna","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"VT323":{"family":"VT323","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Vampiro One":{"family":"Vampiro One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Varela":{"family":"Varela","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Varela Round":{"family":"Varela Round","variants":{"400":"Normal"},"subsets":{"hebrew":"Hebrew","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Varta":{"family":"Varta","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Vast Shadow":{"family":"Vast Shadow","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Vesper Libre":{"family":"Vesper Libre","variants":{"400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Viaoda Libre":{"family":"Viaoda Libre","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Vibes":{"family":"Vibes","variants":{"400":"Normal"},"subsets":{"arabic":"Arabic","latin":"Latin"}},"Vibur":{"family":"Vibur","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Vidaloka":{"family":"Vidaloka","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Viga":{"family":"Viga","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Voces":{"family":"Voces","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Volkhov":{"family":"Volkhov","variants":{"400":"Normal","400italic":"Normal Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin"}},"Vollkorn":{"family":"Vollkorn","variants":{"400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","greek":"Greek","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Vollkorn SC":{"family":"Vollkorn SC","variants":{"400":"Normal","600":"Semi Bold","700":"Bold","900":"Ultra Bold"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Voltaire":{"family":"Voltaire","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Waiting for the Sunrise":{"family":"Waiting for the Sunrise","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Wallpoet":{"family":"Wallpoet","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Walter Turncoat":{"family":"Walter Turncoat","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Warnes":{"family":"Warnes","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Wellfleet":{"family":"Wellfleet","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Wendy One":{"family":"Wendy One","variants":{"400":"Normal"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Wire One":{"family":"Wire One","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Work Sans":{"family":"Work Sans","variants":{"100":"Thin","200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold","800":"Extra Bold","900":"Ultra Bold","100italic":"Thin Italic","200italic":"Extra Light Italic","300italic":"Light Italic","400italic":"Normal Italic","500italic":"Medium Italic","600italic":"Semi Bold Italic","700italic":"Bold Italic","800italic":"Extra Bold Italic","900italic":"Ultra Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Yanone Kaffeesatz":{"family":"Yanone Kaffeesatz","variants":{"200":"Extra Light","300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"cyrillic":"Cyrillic","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Yantramanav":{"family":"Yantramanav","variants":{"100":"Thin","300":"Light","400":"Normal","500":"Medium","700":"Bold","900":"Ultra Bold"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Yatra One":{"family":"Yatra One","variants":{"400":"Normal"},"subsets":{"devanagari":"Devanagari","latin":"Latin","latin-ext":"Latin Extended"}},"Yellowtail":{"family":"Yellowtail","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Yeon Sung":{"family":"Yeon Sung","variants":{"400":"Normal"},"subsets":{"korean":null,"latin":"Latin"}},"Yeseva One":{"family":"Yeseva One","variants":{"400":"Normal"},"subsets":{"cyrillic":"Cyrillic","cyrillic-ext":"Cyrillic Extended","latin":"Latin","latin-ext":"Latin Extended","vietnamese":"Vietnamese"}},"Yesteryear":{"family":"Yesteryear","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Yrsa":{"family":"Yrsa","variants":{"300":"Light","400":"Normal","500":"Medium","600":"Semi Bold","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"ZCOOL KuaiLe":{"family":"ZCOOL KuaiLe","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"ZCOOL QingKe HuangYou":{"family":"ZCOOL QingKe HuangYou","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"ZCOOL XiaoWei":{"family":"ZCOOL XiaoWei","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Zeyada":{"family":"Zeyada","variants":{"400":"Normal"},"subsets":{"latin":"Latin"}},"Zhi Mang Xing":{"family":"Zhi Mang Xing","variants":{"400":"Normal"},"subsets":{"chinese-simplified":null,"latin":"Latin"}},"Zilla Slab":{"family":"Zilla Slab","variants":{"300":"Light","300italic":"Light Italic","400":"Normal","400italic":"Normal Italic","500":"Medium","500italic":"Medium Italic","600":"Semi Bold","600italic":"Semi Bold Italic","700":"Bold","700italic":"Bold Italic"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}},"Zilla Slab Highlight":{"family":"Zilla Slab Highlight","variants":{"400":"Normal","700":"Bold"},"subsets":{"latin":"Latin","latin-ext":"Latin Extended"}}}';

    $google_font_array = json_decode($google_font_json, true);

    return $google_font_array;
}

function total_standard_font_array() {
    return array(
        0 => array(
            'family' => 'Helvetica',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        1 => array(
            'family' => 'Verdana',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        2 => array(
            'family' => 'Arial',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        3 => array(
            'family' => 'Times',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        4 => array(
            'family' => 'Georgia',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        5 => array(
            'family' => 'Courier',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        6 => array(
            'family' => 'Trebuchet',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        7 => array(
            'family' => 'Tahoma',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        ),
        8 => array(
            'family' => 'Palatino',
            'variants' => array(
                '400' => 'Normal',
                '700' => 'Bold'
            ),
            'subsets' => array(
                'latin' => 'Latin'
            )
        )
    );
}
